/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#ifdef MAC
#include <stdlib.h>        /* wg. malloc() */
#include <ctype.h>         /* wg. isalnum() */
#include <string.h>        /* wg. strlen()... */
#include "Mac.h"
#include "pem.h"
#else
#include "pem.h"
#include "cadb.h"
#endif



static int	aux_cpy2_AlgId();

static char
*error_addr_cpy(addr, addrtype)
	char	*addr;
	Struct_No addrtype;
{

	PSESel *dd;

	if (!addr) return((char *)0);

	switch (addrtype) {
	case char_n:
		return((char *)aux_cpy_Name(addr));
	case int_n:
		return(addr);
	case DName_n:
		return((char *)aux_cpy_DName((DName *)addr));
	case Certificate_n:
		return((char *)aux_cpy_Certificate((Certificate *)addr));
	case CertificatePair_n:
		return((char *)aux_cpy_CertificatePair((CertificatePair *)addr));
	case Certificates_n:
		return((char *)aux_cpy_Certificates((Certificates *)addr));
	case PKList_n:
		return((char *)aux_cpy_PKList((PKList *)addr));
	case OctetString_n:
		return((char *)aux_cpy_OctetString((OctetString *)addr));
	case BitString_n:
		return((char *)aux_cpy_BitString((BitString *)addr));
	case SET_OF_Certificate_n:
		return((char *)aux_cpy_SET_OF_Certificate((SET_OF_Certificate *)addr));
	case SET_OF_CertificatePair_n:
		return((char *)aux_cpy_SET_OF_CertificatePair((SET_OF_CertificatePair *)addr));
	case AlgId_n:
		return((char *)aux_cpy_AlgId((AlgId *)addr));
	case OCList_n:
		return((char *)aux_cpy_OCList((OCList *)addr));
	case CrlTBS_n:
		return((char *)aux_cpy_CrlTBS((CrlTBS *)addr));
	case Crl_n:
		return((char *)aux_cpy_Crl((Crl *)addr));
	case RevCert_n:
		return((char *)aux_cpy_RevCert((RevCert *)addr));
	case PemCrlTBS_n:
		return((char *)aux_cpy_PemCrlTBS((PemCrlTBS *)addr));
	case PemCrl_n:
		return((char *)aux_cpy_PemCrl((PemCrl *)addr));
	case RevCertPem_n:
		return((char *)aux_cpy_RevCertPem((RevCertPem *)addr));
	case CrlSet_n:
		return((char *)aux_cpy_CrlSet((CrlSet *)addr));
	case CrlPSE_n:
		return((char *)aux_cpy_CrlPSE ((CrlPSE *)addr));
	case PemInfo_n:
		return((char *)aux_cpy_PemInfo((PemInfo *)addr));
	case KeyInfo_n:
		return((char *)aux_cpy_KeyInfo((KeyInfo *)addr));
	case FCPath_n:
		return((char *)aux_cpy_FCPath((FCPath *)addr));
	case PKRoot_n:
		return((char *)aux_cpy_PKRoot((PKRoot *)addr));
	case IssuedCertificate_n:
		return((char *)aux_cpy_IssuedCertificate((IssuedCertificate *)addr));
	case SET_OF_IssuedCertificate_n:
		return((char *)aux_cpy_SET_OF_IssuedCertificate((SET_OF_IssuedCertificate *)addr));
	case SET_OF_Name_n:
		return((char *)aux_cpy_SET_OF_Name((SET_OF_Name *)addr));
	case ToBeSigned_n:
		return((char *)aux_cpy_ToBeSigned((ToBeSigned *)addr));
	case ObjId_n:
		return((char *)aux_cpy_ObjId((ObjId *)addr));
	case KeyBits_n:
		return((char *)aux_cpy_KeyBits((KeyBits *)addr));
	case PSEToc_n:
		return((char *)aux_cpy_PSEToc((PSEToc *)addr));
	case PSESel_n:
		dd = aux_cpy_PSESel((PSESel *)addr);
		if(dd->pin) strzfree(&(dd->pin));
		if(dd->object.pin) strzfree(&(dd->object.pin));
		return((char *)dd);
	}
	return((char *)0);

}


int aux_create_AFPSESel(appname, pin)
char * appname;
char * pin;
{
	int 	   i, pinlen;
	char	 * proc = "aux_create_AFPSESel";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!appname) return - 1;

	AF_pse.app_name = aux_cpy_String(appname);

	if (!pin) {
		AF_pse.pin = CNULL;
		for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = CNULL;
		return 0;
	}

	AF_pse.pin = aux_cpy_String(pin);

	for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = aux_cpy_String(pin);

	return 0;
}


void aux_add_error(number, text, addr, addrtype, proc)
int	number;
char	*text;
char	*addr;
Struct_No addrtype;
char	*proc;
{
	struct ErrStack  * err;
	char		 * local_proc = "aux_add_error";

#ifdef TEST
	fprintf(stderr, "%s\n", local_proc);	
#endif

        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_number   = number;
		err->e_text     = text;
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} else {
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}
        return;
}

int aux_last_error() {
	if(err_stack) return(err_stack->e_number);
	else return(0);
}


ObjId *aux_cpy_ObjId(oid)
ObjId *oid;
{
	ObjId   * dup_oid;
	char	* proc = "aux_cpy_ObjId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) )
		return( (ObjId * )0 );

	if ( (dup_oid = (ObjId * )malloc(sizeof(ObjId)))
	     == (ObjId * )0 ) {
		aux_add_error(EMALLOC, "dup_oid", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	if (aux_cpy2_ObjId (dup_oid, oid)) {
		aux_add_error(EINVALID, "aux_cpy2_ObjId failed", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	return( dup_oid );
}


PSESel *aux_cpy_PSESel(psesel)
PSESel *psesel;
{
	PSESel  * dup_psesel;
	char	* proc = "aux_cpy_PSESel";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
	if(!psesel) return((PSESel *)0);

	if ( (dup_psesel = (PSESel * )calloc(1, sizeof(PSESel))) == (PSESel * )0 ) {
		aux_add_error(EMALLOC, "dup_PSESel", CNULL, 0, proc);
		return( (PSESel * )0 );
	}

	dup_psesel->app_name = aux_cpy_String(psesel->app_name);
	dup_psesel->pin = aux_cpy_String(psesel->pin);
	dup_psesel->object.name = aux_cpy_String(psesel->object.name);
	dup_psesel->object.pin = aux_cpy_String(psesel->object.pin);
	dup_psesel->app_id = psesel->app_id;
	return(dup_psesel);
}


int	aux_cpy2_ObjId(dup_oid, oid)
ObjId *dup_oid;
ObjId *oid;
{
	int	  i;
	char	* proc = "aux_cpy2_ObjId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (oid == (ObjId * )0) || (dup_oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_oid->oid_nelem = oid->oid_nelem;
	if ( !dup_oid->oid_nelem ) {
		dup_oid->oid_nelem = 0;
		dup_oid->oid_elements = (unsigned *)0;
	} else {
		if ( (dup_oid->oid_elements
		     = (unsigned int *)malloc(oid->oid_nelem * sizeof(unsigned int)))
		     == (unsigned int *)0 ) {
			aux_add_error(EMALLOC, "dup_oid->oid_elements", CNULL, 0, proc);
			return( -1 );
		} else
			for ( i = 0; i < oid->oid_nelem; i++)
				dup_oid->oid_elements[i] = oid->oid_elements[i];
	}
	return( 0 );
}


int	aux_cmp_ObjId(oid1, oid2)
ObjId *oid1, *oid2;
{
	int	  i;
	char	* proc = "aux_cmp_ObjId";

	if ( !oid1 || !oid2 )
		return( 1) ;

	if ( oid1->oid_nelem == oid2->oid_nelem ) {
		for ( i = 0; i < oid1->oid_nelem; i++) {
			if ( oid1->oid_elements[i] != oid2->oid_elements[i] )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}


AlgId *aux_cpy_AlgId(aid)
AlgId *aid;
{
	AlgId   * dup_aid;
	char	* proc = "aux_cpy_AlgId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (aid == (AlgId * )0) || (aid->objid == (ObjId * )0) )
		return( (AlgId * )0 );


	if ( (dup_aid = (AlgId * )malloc(sizeof(AlgId))) == (AlgId * )0 ) {
		aux_add_error(EMALLOC, "dup_aid", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	if (aux_cpy2_AlgId (dup_aid, aid)) {
		aux_add_error(EINVALID, "aux_cpy2_AlgId failed", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	return( dup_aid );
}


static
int	aux_cpy2_AlgId(dup_aid, aid)
AlgId *dup_aid;
AlgId *aid;
{
	int			   i;
	rsa_parm_type    	 * rsa_p1;
	desCBC_parm_type 	 * des_p1, * des_p2;
	char			 * proc = "aux_cpy2_AlgId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (aid == (AlgId * )0) || (dup_aid == (AlgId * )0) || (aid->objid == (ObjId * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_aid->objid = aux_cpy_ObjId(aid->objid);
	if (!dup_aid->objid) {
		aux_add_error(EINVALID, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return(-1);
	}

	if ( !aid->parm ) {
		dup_aid->parm = (char *)0 ;
		return( 0 );
	}

	switch ( aux_ObjId2ParmType( dup_aid->objid ) ) {

	case PARM_INTEGER:
		if ( !(rsa_p1 = (rsa_parm_type * )malloc(sizeof(rsa_parm_type))) ) {
			aux_add_error(EMALLOC, "rsa_p1", CNULL, 0, proc);
			return( -1 );
		}
		*rsa_p1 = RSA_PARM(aid->parm);
		dup_aid->parm = (char *)rsa_p1;
		break;
	case PARM_OctetString:
		if ( !(des_p1 = (desCBC_parm_type * )
		    malloc(sizeof(desCBC_parm_type))) ) {
			aux_add_error(EMALLOC, "des_p1", CNULL, 0, proc);
			return( -1 );
		}
		des_p2 = (desCBC_parm_type * )(aid->parm);
		des_p1->noctets = des_p2->noctets;
		if(des_p1->noctets) {
			if ( !(des_p1->octets = (char *)malloc(des_p1->noctets)) ) {
				aux_add_error(EMALLOC, "des_p1->octets", CNULL, 0, proc);
				return( -1 );
			}
			for ( i = 0; i < des_p1->noctets; i++) {
				des_p1->octets[i] = des_p2->octets[i];
			}
		}
		else des_p1->octets = aux_cpy_String("");
		dup_aid->parm = (char *)des_p1;
		break;
	default:
		/* non-standard parm ignored */
		dup_aid->parm = (char *)0;
		break;
	}
	return( 0 );
}


int	aux_cmp_AlgId(aid1, aid2)
AlgId *aid1, *aid2;
{
	int	i;
	rsa_parm_type     * rsa_p1, *rsa_p2;
	desCBC_parm_type * des_p1, *des_p2;
	char	*proc = "aux_cmp_AlgId";

	if ( !aid1 || !aid2 )
		return( 1) ;

	if ( !aux_cmp_ObjId(aid1->objid, aid2->objid) ) {

		if ( !aid1->parm || !aid2->parm ) {
			if ( !aid1->parm && !aid2->parm )
				return( 0 );
			else
				return( 1 );
		}

		switch ( aux_ObjId2ParmType( aid1->objid ) ) {

		case PARM_INTEGER:
			rsa_p1 = (rsa_parm_type * )(aid1->parm);
			rsa_p2 = (rsa_parm_type * )(aid2->parm);
			if ( *rsa_p1 == *rsa_p2 )
				return( 0 );
			else
				return( 1 );
		case PARM_OctetString:
			des_p1 = (desCBC_parm_type * )(aid1->parm);
			des_p2 = (desCBC_parm_type * )(aid2->parm);
			if ( des_p1->noctets == des_p2->noctets ) {
				for ( i = 0; i < des_p1->noctets; i++) {
					if ( des_p1->octets[i] != des_p2->octets[i] )
						return( 1 );
				}
				return( 0 );
			} else
				return( 1 );

		default:
			/* objids are equal, but parms cannot be compared */
			return( 1 );
		}
	} else
		return( 1 );
}


KeyInfo *aux_cpy_KeyInfo(keyinfo)
KeyInfo *keyinfo;
{
	KeyInfo * dup_ki;
	char	* proc = "aux_cpy_KeyInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ((keyinfo == (KeyInfo * )0))
		return( (KeyInfo * )0);
	if ((dup_ki = (KeyInfo * )malloc(sizeof(KeyInfo))) == (KeyInfo * )0 ) {
		aux_add_error(EMALLOC, "dup_ki", CNULL, 0, proc);
		return((KeyInfo * )0);
	}
	if (aux_cpy2_KeyInfo (dup_ki, keyinfo)) {
		aux_add_error(EINVALID, "aux_cpy2_KeyInfo failed", CNULL, 0, proc);
		return( (KeyInfo * )0 );
	}
	return(dup_ki);
}


int	aux_cpy2_KeyInfo (dup_ki, keyinfo)
KeyInfo *dup_ki;
KeyInfo *keyinfo;
{
	int	  i, nob;
	char	* proc = "aux_cpy2_KeyInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (keyinfo == (KeyInfo * )0) || (dup_ki == (KeyInfo * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}


	dup_ki->subjectAI = aux_cpy_AlgId(keyinfo->subjectAI);
	if (!dup_ki->subjectAI) {
		aux_add_error(EINVALID, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_BitString(&dup_ki->subjectkey, &keyinfo->subjectkey)) {
		aux_add_error(EINVALID, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


int	aux_cmp_BitString(bitstring1, bitstring2)
BitString *bitstring1, *bitstring2;
{
	int	  i, nob, rob;
	char	* proc = "aux_cmp_Bitstring";

	if ( (nob = bitstring1->nbits) == bitstring2->nbits ) {
		rob = nob % 8;
		nob = nob / 8;
		for ( i = 0; i < nob; i++) {
			if ( bitstring1->bits[i] != 
			    bitstring2->bits[i] )
				return( 1 );
		}
		if ( rob ) {
			if ( ((unsigned char)bitstring2->bits[nob] >> (8 - rob)) != 
			    ((unsigned char)bitstring1->bits[nob] >> (8 - rob)) )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}

int	aux_cmp_KeyInfo(keyinfo1, keyinfo2)
KeyInfo *keyinfo1, *keyinfo2;
{
	char	* proc = "aux_cmp_KeyInfo";

	if ( !aux_cmp_AlgId(keyinfo1->subjectAI, keyinfo2->subjectAI) ) {
		return( aux_cmp_BitString(&keyinfo1->subjectkey, &keyinfo2->subjectkey) );
	} else
		return( 1 );
}


char	*aux_ObjId2PSEObjectName(given_objid)
ObjId *given_objid;
{
	register int   i;
	char	     * proc = "aux_ObjId2PSEObjectName";

	if (!given_objid) return((char *)0);

	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!aux_cmp_ObjId(given_objid, AF_pse.object[i].oid))
			return(aux_cpy_Name(AF_pse.object[i].name));
	}
	return((char *)0);
}

ObjId *aux_PSEObjectName2ObjId(name)
char	*name;
{
	register int   i;
	char	     * proc = "aux_PSEObjectName2ObjId";

	if (!name) return((ObjId * )0);
	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!strcmp(name, AF_pse.object[i].name))
			return(aux_cpy_ObjId(AF_pse.object[i].oid));
	}
	return((ObjId * )0);
}

ObjId *aux_Name2ObjId(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ObjId";

	if (!name)
		return((ObjId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_ObjId(a->algid->objid));
		a++;
	}
	return((ObjId * )0);
}


AlgId *aux_Name2AlgId(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgId";

	if (!name)
		return((AlgId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


AlgType aux_Name2AlgType(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgType";

	if (!name)
		return(OTHER_ALG);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algtype);
		a++;
	}
	return(OTHER_ALG);
}


AlgEnc aux_Name2AlgEnc(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgEnc";

	if (!name)
		return(NOENC);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algenc);
		a++;
	}
	return(NOENC);
}


AlgHash aux_Name2AlgHash(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgHash";

	if (!name)
		return(NOHASH);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->alghash);
		a++;
	}
	return(NOHASH);
}


AlgMode aux_Name2AlgMode(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgMode";

	if (!name)
		return(NOMODE);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algmode);
		a++;
	}
	return(NOMODE);
}

AlgSpecial aux_Name2AlgSpecial(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgSpecial";

	if (!name)
		return(NOSPECIAL);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algspecial);
		a++;
	}
	return(NOSPECIAL);
}

ParmType aux_Name2ParmType(name)
char	*name;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ParmType";

	if (!name)
		return(-1);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->parmtype);
		a++;
	}
	return(-1);
}




char	*aux_ObjId2Name(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2Name";

	if (!given_objid)
		return((char *)0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_Name(a->name));
		a++;
	}
	return((char *)0);
}


AlgType aux_ObjId2AlgType(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgType";

	if (!given_objid)
		return(OTHER_ALG);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algtype);
		a++;
	}
	return(OTHER_ALG);
}


AlgEnc aux_ObjId2AlgEnc(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgEnc";

	if (!given_objid)
		return(NOENC);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algenc);
		a++;
	}
	return(NOENC);
}


AlgHash aux_ObjId2AlgHash(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgHash";

	if (!given_objid)
		return(NOHASH);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->alghash);
		a++;
	}
	return(NOHASH);
}

AlgSpecial aux_ObjId2AlgSpecial(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgSpecial";

	if (!given_objid)
		return(NOSPECIAL);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algspecial);
		a++;
	}
	return(NOSPECIAL);
}

AlgMode aux_ObjId2AlgMode(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgMode";

	if (!given_objid)
		return(NOMODE);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algmode);
		a++;
	}
	return(NOMODE);
}

AlgId *aux_ObjId2AlgId(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgId";

	if (!given_objid)
		return((AlgId * )0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


ParmType aux_ObjId2ParmType(given_objid)
ObjId *given_objid;
{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2ParmType";

	if (!given_objid)
		return(-1);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->parmtype);
		a++;
	}
	return(-1);
}


ObjId *aux_oid2syntaxoid(given_objid)
ObjId *given_objid;
{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2syntaxoid";

	if (!given_objid)
		return((ObjId * )0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(aux_cpy_ObjId(a->syntax_oid));
		a++;
	}
	return((ObjId * )0);
}


Name *aux_cpy_Name(namefrom)
char	*namefrom;
{
	char	* nameto;
	char	* proc = "aux_cpy_Name";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( ! namefrom )
		return ( (Name *) 0);

	nameto = (char *)malloc(strlen(namefrom) + 1);
	if (!nameto)  {
		aux_add_error(EMALLOC, "nameto", CNULL, 0, proc);
		return(nameto);
	}
	strcpy(nameto, namefrom);
	return(nameto);
}


/*
 *	cut off blanks at begin and end of string a
 *	return pointer to successfully reduced and allocated string, else NULL
 *	return NULL if string a consists of blanks only
 */

char
*aux_cpy_ReducedString(a)
char *a;
{
	register char *aa, *afirst, *alast;

	if (!a || !strcmp(a, "") || !(aa = aux_cpy_String(a)) ) return(CNULL);
	afirst = aa;
	while (afirst)  {
		if (*afirst != ' ') break;
		afirst++;
	}
	if (!*afirst)  {
		if (aa) free(aa);
		return(CNULL);
	}
	alast = aa + strlen(aa);
	while (--alast) if (*alast != ' ') break;
	if (alast < aa) return(aa);
	*(++alast) = '\0';
	strcpy(aa, afirst);
	return(aa);
}
		


aux_pstrcmp (a, b)
register char	*a, *b;
{
	while (*a == *b) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (*a > *b)
		return (1);
	else
		return (-1);

}


static aux_tlexequ (a, b)
register char	*a, *b;
{

	while (chrcnv[*a] == chrcnv[*b]) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (chrcnv[*a] > chrcnv[*b])
		return (1);
	else
		return (-1);
}


aux_lexequ (str1, str2)
register char	*str1,
*str2;
{
	if (!str1)
		if (!str2)
			return (0);
		else
			return (-1);

	if (!str2)
		return (1);

	while (chrcnv[*str1] == chrcnv[*str2]) {
		if (*str1++ == 0)
			return (0);
		str2++;
	}

	if (chrcnv[*str1] > chrcnv[*str2])
		return (1);
	else
		return (-1);
}


int	aux_cmp_Name(name1, name2)
char	*name1, *name2;
{
	DName  * dname1, *dname2;
	int	 ret;
	char   * proc = "aux_cmp_Name";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	dname1 = aux_Name2DName(name1);
	dname2 = aux_Name2DName(name2);
	if (!dname1 || !dname2) {
		aux_add_error(EINVALID, "aux_Name2DName failed", CNULL, 0, proc);
		return(-1);
	}
	ret = aux_cmp_DName(dname1, dname2);
	aux_free2_DName(dname1);
	aux_free2_DName(dname2);

	return(ret);
}


int	RDName_comp_cmp (a, b)
RDName  *a, *b;
{
	int	  avlen, ret;
	char	* a_value, * b_value;
	ObjId   * syntax_oid;
	char	* proc = "RDName_comp_cmp";

	if(!aux_cmp_ObjId(a->member_IF_0->element_IF_0, b->member_IF_0->element_IF_0) ) {
		syntax_oid = aux_oid2syntaxoid(a->member_IF_0->element_IF_0);
		a_value = prim2str(a->member_IF_0->element_IF_1, &avlen );
		b_value = prim2str(b->member_IF_0->element_IF_1, &avlen );
		if(!aux_cmp_ObjId(syntax_oid, CountryString)) ret = aux_lexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, CaseIgnoreString)) ret = aux_tlexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, PrintableString)) ret = aux_pstrcmp(a_value, b_value);
		else ret = 1;  /*unknown syntax_oid*/
		aux_free_ObjId(&syntax_oid);
		free(a_value);
		free(b_value);
		return(ret);
	} 
	else return(1);
}


int	aux_cmp_RDName (a, b)
register RDName  *a, *b;
{
	char	*proc = "aux_cmp_RDName";

	for (; (a != NULLRDNAME) && (b != NULLRDNAME) ; a = a->next, b = b->next) {
		if ( RDName_comp_cmp(a, b) ) return( 1 );
	}

	if ( (a == NULLRDNAME) && (b == NULLRDNAME) )  {
		return( 0 );
	} 
	else return( 1 );
}


int	aux_cmp_DName (a, b)
register DName  *a, *b;
{
	char	*proc = "aux_cmp_DName";

	for (; (a != NULLDNAME) && (b != NULLDNAME) ; a = a->next, b = b->next) {
		if ( aux_cmp_RDName(a->element_IF_2, b->element_IF_2) )
			return( 1 );
	}

	if (( a == NULLDNAME) && (b == NULLDNAME)) {
		return( 0 );
	} else
		return( 1 );
}


RC aux_checkPemDNameSubordination(sup, sub)
DName * sup;
DName * sub;
{
	/* Return Value:
	       -1       error
		0	"sub" is NOT subordinate to "sup"
		1	"sub" is subordinate to "sup"
	*/

	char	*proc = "aux_checkPemDNameSubordination";

	if (! sup || ! sub) {
		aux_add_error(EINVALID, "required parameters NOT provided", CNULL, 0, proc);
		return (- 1);
	}

	for (; (sup != NULLDNAME) && (sub != NULLDNAME) ; sup = sup->next, sub = sub->next) {
		if ( aux_cmp_RDName(sup->element_IF_2, sub->element_IF_2) )
			return (FALSE);
	}

	if ( (sup == NULLDNAME && sub == NULLDNAME) || (sup != NULLDNAME && sub == NULLDNAME) )
		return (FALSE);

	/* sup == NULLDNAME && sub != NULLDNAME */
	return (TRUE);

}


RDName  *aux_cpy_RDName_comp (rdn)
RDName  *rdn;
{
	register RDName * ptr;
	char		* proc = "aux_cpy_RDName_comp";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}

	ptr = (struct type_IF_RelativeDistinguishedName *)malloc(
	    sizeof(struct type_IF_RelativeDistinguishedName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "ptr", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0 = (struct type_IF_AttributeValueAssertion *)malloc(
	    sizeof(struct type_IF_AttributeValueAssertion ) );
	if (!ptr->member_IF_0) {
		aux_add_error(EMALLOC, "ptr->member_IF_0", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_0 = (OIDentifier * )aux_cpy_ObjId(rdn->member_IF_0->element_IF_0);
	if (!ptr->member_IF_0->element_IF_0) {
		aux_add_error(EINVALID, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_1 = pe_cpy(rdn->member_IF_0->element_IF_1);
	ptr->next = NULLRDNAME;

	return (ptr);
}


RDName  *aux_cpy_RDName (rdn)
RDName  *rdn;
{
	RDName * start;
	register RDName *eptr;
	register RDName *ptr, *ptr2;
	char	*proc = "aux_cpy_RDName";

	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}
	start = aux_cpy_RDName_comp (rdn);
	if (!start) {
		aux_add_error(EINVALID, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr2 = start;

	for (eptr = rdn->next; eptr != NULLRDNAME; eptr = eptr->next) {
		ptr = aux_cpy_RDName_comp (eptr);
		if (!ptr) {
			aux_add_error(EINVALID, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
			return (NULLRDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


DName  *aux_cpy_DName_comp (dn)
register DName  *dn;
{
	register DName  * ptr;
	char		* proc = "aux_cpy_DName_comp";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	ptr = (struct type_IF_Name *)malloc(sizeof(struct type_IF_Name ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->element_IF_2 = aux_cpy_RDName (dn->element_IF_2);
	if (!ptr->element_IF_2) {
		aux_add_error(EINVALID, "aux_cpy_RDName failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->next = NULLDNAME;
	return (ptr);
}


DName  *aux_cpy_DName (dn)
register DName  *dn;
{
	DName 	        * start;
	register DName  * eptr, * ptr, * ptr2;
	char		* proc = "aux_cpy_DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	start = aux_cpy_DName_comp (dn);
	if (!start) {
		aux_add_error(EINVALID, "aux_cpy_DName_comp failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr2 = start;
	for (eptr = dn->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(EINVALID, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return (NULLDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


int	aux_cpy2_DName_comp (dup_dname, dname)
DName *dup_dname;
DName *dname;
{
	char	* proc = "aux_cpy2_DName_comp";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_dname->element_IF_2 = aux_cpy_RDName (dname->element_IF_2);
	if (!dup_dname->element_IF_2) {
		aux_add_error(EINVALID, "aux_cpy_RDName failed", CNULL, 0, proc);
		return(-1);
	}
	dup_dname->next = NULLDNAME;
	return (0);
}


int	aux_cpy2_DName (dup_dname, dname)
DName *dup_dname;
DName *dname;
{
	register DName * eptr, * ptr, * ptr2;
	int              rcode;
	char	       * proc = "aux_cpy2_DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	rcode = aux_cpy2_DName_comp (dup_dname, dname);
	if (rcode < 0) {
		aux_add_error(EINVALID, "aux_cpy2_DName_comp failed", CNULL, 0, proc);
		return(-1);
	}
	ptr2 = dup_dname;
	for (eptr = dname->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(EINVALID, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return(-1);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}

	return( 0 );
}


ObjId *aux_keyword2oid(keyword)
char	*keyword;
{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2oid";

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(aux_cpy_ObjId(a->objid));
		if (strcmp(keyword, a->keyword) == 0)
			return(aux_cpy_ObjId(a->objid));
		a++;
	}
	return((ObjId * )0);
}


ObjId *aux_keyword2syntaxoid(keyword)
char	*keyword;
{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2syntaxoid";

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(a->syntax_oid);
		if (strcmp(keyword, a->keyword) == 0)
			return(a->syntax_oid);
		a++;
	}
	return((ObjId * )0);
}


char	*aux_oid2keyword(given_objid)
ObjId *given_objid;
{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2keyword";

	if (!given_objid)
		return((char *)0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(a->abbrev);
		a++;
	}
	return((char *)0);
}



Certificate *aux_cpy_Certificate(cert)
Certificate *cert;
{
	int	      i, nob, lim;
	Certificate * dup_cert;
	char	    * proc = "aux_cpy_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (cert == (Certificate * )0) )
		return( (Certificate * )0 );
	if ( (dup_cert = (Certificate * )malloc(sizeof(Certificate))) == (Certificate * )0 ) {
		aux_add_error(EMALLOC, "dup_cert", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	if (aux_cpy2_Certificate (dup_cert, cert)) {
		aux_add_error(EINVALID, "aux_cpy2_Certificate failed", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	return( dup_cert );
}


Signature *aux_cpy_Signature(sig)
Signature *sig;
{
	Signature  * dup_sig;
	char	   * proc = "aux_cpy_Signature";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!sig)
		return ( (Signature * ) 0);

	if ( !(dup_sig = (Signature * )malloc(sizeof(Signature))) ) {
		aux_add_error(EMALLOC, "dup_sig", CNULL, 0, proc);
		return ( (Signature * ) 0);
	}
	dup_sig->signAI = aux_cpy_AlgId(sig->signAI);
	if (aux_cpy2_BitString (&dup_sig->signature, &sig->signature)) {
		aux_add_error(EINVALID, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return ( (Signature * ) 0);
	}

	return(dup_sig);
}


int	aux_cpy2_Certificate (dup_cert, cert)
Certificate *dup_cert;
Certificate *cert;
{
	char	* proc = "aux_cpy2_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (cert == (Certificate * )0) || (dup_cert == (Certificate * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_cert->tbs_DERcode = aux_cpy_OctetString(cert->tbs_DERcode);
	dup_cert->tbs = aux_cpy_ToBeSigned(cert->tbs);
	dup_cert->sig = aux_cpy_Signature(cert->sig);

	return( 0 );
}


int	aux_cpy2_OctetString(dup_ostr, ostr)
OctetString *dup_ostr;
OctetString *ostr;
{
	int	  i;
	char	* proc = "aux_cpy2_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (ostr == (OctetString * )0) || (dup_ostr == (OctetString * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_ostr->noctets = ostr->noctets;
	if(dup_ostr->noctets) {
		if ( (dup_ostr->octets = (char *)malloc(dup_ostr->noctets)) == (char *)0 ) {
			aux_add_error(EMALLOC, "dup_ostr->octets", CNULL, 0, proc);
			return( -1 );
		}
	}
	else {
		if(ostr->octets) dup_ostr->octets = aux_cpy_String("");
		else dup_ostr->octets = CNULL;
	}
	for ( i = 0; i < dup_ostr->noctets; i++) {
		dup_ostr->octets[i] = ostr->octets[i];
	}
	return( 0 );
}


int	aux_cpy2_BitString(dup_bstr, bstr)
BitString *dup_bstr;
BitString *bstr;
{
	int	  i, nob;
	char	* proc = "aux_cpy2_BitString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (bstr == (BitString * )0) || (dup_bstr == (BitString * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_bstr->nbits = bstr->nbits;
	nob = dup_bstr->nbits / 8;
	if ( dup_bstr->nbits % 8 )
		nob++;
	if ( (dup_bstr->bits = (char *)malloc(nob)) == (char *)0 ) {
		aux_add_error(EMALLOC, "dup_bstr->bits", CNULL, 0, proc);
		return( 0 );
	}
	for ( i = 0; i < nob; i++) {
		dup_bstr->bits[i] = bstr->bits[i];
	}
	return( 0 );
}


OctetString *aux_cpy_OctetString(ostr)
OctetString *ostr;
{
	OctetString * dup_ostr;
	char	    * proc = "aux_cpy_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!ostr)
		return (NULLOCTETSTRING);

	if ( !(dup_ostr = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "dup_ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	if (aux_cpy2_OctetString(dup_ostr, ostr)) {
		aux_add_error(EINVALID, "aux_cpy2_OctetString failed", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	return(dup_ostr);
}


BitString *aux_cpy_BitString(bstr)
BitString *bstr;
{
	BitString * dup_bstr;
	int	    nob, i;
	char	  * proc = "aux_cpy_BitString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!bstr)
		return (NULLBITSTRING);

	if ( !(dup_bstr = (BitString * )malloc(sizeof(BitString))) ) {
		aux_add_error(EMALLOC, "dup_bstr", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	if (aux_cpy2_BitString(dup_bstr, bstr)) {
		aux_add_error(EINVALID, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	return(dup_bstr);
}


PKList *aux_cpy_PKList(list)
PKList *list;
{
	PKList  * dup_list;
	char	* proc = "aux_cpy_PKList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!list)
		return ( (PKList * ) 0);
	if ( !(dup_list = (PKList * )malloc(sizeof(PKList))) ) {
		aux_add_error(EMALLOC, "dup_list", CNULL, 0, proc);
		return ( (PKList * ) 0);
	}
	dup_list->element = aux_cpy_ToBeSigned(list->element);
	dup_list->next = aux_cpy_PKList(list->next);

	return(dup_list);
}


Certificates * aux_cpy_Certificates(certs)
Certificates * certs;
{
	Certificates * dup_certs;
	char	     * proc = "aux_cpy_Certificates";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!certs)
		return ( (Certificates * ) 0);

	if ( !(dup_certs = (Certificates * )malloc(sizeof(Certificates))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (Certificates * ) 0);
	}
	dup_certs->usercertificate = aux_cpy_Certificate(certs->usercertificate);
	dup_certs->forwardpath = aux_cpy_FCPath(certs->forwardpath);

	return (dup_certs);
}


CertificatePair * aux_cpy_CertificatePair(certs)
CertificatePair * certs;
{
	CertificatePair * dup_certs;
	char	        * proc = "aux_cpy_CertificatePair";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!certs)
		return ( (CertificatePair * ) 0);

	if ( !(dup_certs = (CertificatePair * )malloc(sizeof(CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (CertificatePair * ) 0);
	}
	dup_certs->forward = aux_cpy_Certificate(certs->forward);
	dup_certs->reverse = aux_cpy_Certificate(certs->reverse);

	return(dup_certs);
}


SET_OF_Certificate *aux_cpy_SET_OF_Certificate(certs)
SET_OF_Certificate *certs;
{
	SET_OF_Certificate * dup_certs;
	char		   * proc = "aux_cpy_SET_OF_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!certs)
		return ( (SET_OF_Certificate * ) 0);

	if ( !(dup_certs = (SET_OF_Certificate * )malloc(sizeof(SET_OF_Certificate))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_Certificate * ) 0);
	}
	dup_certs->element = aux_cpy_Certificate(certs->element);
	dup_certs->next = aux_cpy_SET_OF_Certificate(certs->next);

	return(dup_certs);
}


SET_OF_Name *aux_cpy_SET_OF_Name(nameset)
SET_OF_Name *nameset;
{
	SET_OF_Name * dup_nameset;
	char	    * proc = "aux_cpy_SET_OF_Name";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!nameset)
		return ( (SET_OF_Name * ) 0);

	if ( !(dup_nameset = (SET_OF_Name * )malloc(sizeof(SET_OF_Name))) ) {
		aux_add_error(EMALLOC, "dup_nameset", CNULL, 0, proc);
		return ( (SET_OF_Name * ) 0);
	}
	dup_nameset->element = aux_cpy_Name(nameset->element);
	dup_nameset->next = aux_cpy_SET_OF_Name(nameset->next);

	return(dup_nameset);
}


SET_OF_CertificatePair *aux_cpy_SET_OF_CertificatePair(certs)
SET_OF_CertificatePair *certs;
{
	SET_OF_CertificatePair * dup_certs;
	char		       * proc = "aux_cpy_SET_OF_CertificatePair";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!certs)
		return ( (SET_OF_CertificatePair * ) 0);

	if ( !(dup_certs = (SET_OF_CertificatePair * )malloc(sizeof(SET_OF_CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_CertificatePair * ) 0);
	}
	dup_certs->element = aux_cpy_CertificatePair(certs->element);
	dup_certs->next = aux_cpy_SET_OF_CertificatePair(certs->next);

	return(dup_certs);
}


FCPath *aux_cpy_FCPath(fcpath)
FCPath *fcpath;
{
	FCPath  * dup_fcpath;
	char	* proc = "aux_cpy_FCPath";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!fcpath)
		return ( (FCPath * ) 0);

	if ( !(dup_fcpath = (FCPath * )malloc(sizeof(FCPath))) ) {
		aux_add_error(EMALLOC, "dup_fcpath", CNULL, 0, proc);
		return ( (FCPath * ) 0);
	}
	dup_fcpath->liste = aux_cpy_SET_OF_Certificate(fcpath->liste);
	dup_fcpath->next_forwardpath = aux_cpy_FCPath(fcpath->next_forwardpath);

	return(dup_fcpath);
}


RecpList *aux_cpy_RecpList(list)
RecpList *list;
{
	RecpList * dup_list;
	char	 * proc = "aux_cpy_RecpList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!list)
		return ( (RecpList * ) 0);

	if ( !(dup_list = (RecpList * )malloc(sizeof(RecpList))) ) {
		aux_add_error(EMALLOC, "dup_list", CNULL, 0, proc);
		return ( (RecpList * ) 0);
	}
	dup_list->recpcert = aux_cpy_Certificate(list->recpcert);
	dup_list->key = aux_cpy_OctetString(list->key);
	dup_list->next = aux_cpy_RecpList(list->next);

	return(dup_list);
}


ToBeSigned *aux_cpy_ToBeSigned(tbs)
ToBeSigned *tbs;
{
	ToBeSigned * dup_tbs;
	char	   * proc = "aux_cpy_ToBeSigned";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!tbs)
		return ( (ToBeSigned * ) 0);

	if ( !(dup_tbs = (ToBeSigned * )malloc(sizeof(ToBeSigned))) ) {
		aux_add_error(EMALLOC, "dup_tbs", CNULL, 0, proc);
		return ( (ToBeSigned * ) 0);
	}
	dup_tbs->version = tbs->version;
	dup_tbs->serialnumber = tbs->serialnumber;
	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->notbefore = aux_cpy_Name(tbs->notbefore);
	dup_tbs->notafter = aux_cpy_Name(tbs->notafter);
	dup_tbs->subject = aux_cpy_DName(tbs->subject);
	dup_tbs->subjectPK = aux_cpy_KeyInfo(tbs->subjectPK);

#ifdef COSINE
	if (tbs->authatts) {
		if ( !(dup_tbs->authatts = (AuthorisationAttributes * )
					 malloc(sizeof(AuthorisationAttributes))) ) {
			aux_add_error(EMALLOC, "dup_tbs->authatts", CNULL, 0, proc);
			return ( (ToBeSigned * ) 0);
		}
		dup_tbs->authatts->country = aux_cpy_Name(tbs->authatts->country);
		dup_tbs->authatts->group = aux_cpy_Name(tbs->authatts->group);
		dup_tbs->authatts->class = tbs->authatts->class;
	}
	else
		dup_tbs->authatts = (AuthorisationAttributes * ) 0;
#endif

	return(dup_tbs);
}


KeyBits *aux_cpy_KeyBits(keybits)
KeyBits *keybits;
{
	KeyBits * dup_keybits;
	char	* proc = "aux_cpy_KeyBits";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!keybits)
		return ( (KeyBits * ) 0);

	if ( !(dup_keybits = (KeyBits * )malloc(sizeof(KeyBits))) ) {
		aux_add_error(EMALLOC, "dup_keybits", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part1, &keybits->part1)) {
		aux_add_error(EINVALID, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part2, &keybits->part2)) {
		aux_add_error(EINVALID, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part3, &keybits->part3)) {
		aux_add_error(EINVALID, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part4, &keybits->part4)) {
		aux_add_error(EINVALID, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}

	return(dup_keybits);
}


Key *aux_cpy_Key(key)
Key *key;
{
	Key     * dup_key;
	char	* proc = "aux_cpy_Key";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!key)
		return ( (Key * ) 0);

	if ( !(dup_key = (Key * )malloc(sizeof(Key))) ) {
		aux_add_error(EMALLOC, "dup_key", CNULL, 0, proc);
		return ( (Key * ) 0);
	}
	dup_key->key = aux_cpy_KeyInfo(key->key);
	dup_key->keyref = key->keyref;
	dup_key->pse_sel = aux_cpy_PSESel(key->pse_sel);
	dup_key->alg = aux_cpy_AlgId(key->alg);

	return(dup_key);
}


PSEToc *aux_cpy_PSEToc(pse)
PSEToc *pse;
{
	PSEToc  * dup_pse;
	char	* proc = "aux_cpy_PSEToc";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!pse)
		return ( (PSEToc * ) 0);

	if ( !(dup_pse = (PSEToc * )malloc(sizeof(PSEToc))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEToc * ) 0);
	}
	dup_pse->owner = aux_cpy_Name(pse->owner);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->obj = aux_cpy_PSEObjects(pse->obj);

	return(dup_pse);
}


struct PSE_Objects *aux_cpy_PSEObjects(pse)
struct PSE_Objects *pse;
{
	struct PSE_Objects * dup_pse;
	char		   * proc = "aux_cpy_PSEObjects";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!pse)
		return ( (struct PSE_Objects * ) 0);

	if ( !(dup_pse = (struct PSE_Objects *)malloc(sizeof(struct PSE_Objects ))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (struct PSE_Objects * ) 0);
	}
	dup_pse->name = aux_cpy_Name(pse->name);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->noOctets = pse->noOctets;
	dup_pse->status = pse->status;
	dup_pse->next = aux_cpy_PSEObjects(pse->next);

	return(dup_pse);
}


PSEObject *aux_cpy_PSEObject(pse)
PSEObject *pse;
{
	PSEObject * dup_pse;
	char	  * proc = "aux_cpy_PSEObject";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!pse)
		return ( (PSEObject * ) 0);

	if ( !(dup_pse = (PSEObject * )malloc(sizeof(PSEObject))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEObject * ) 0);
	}
	dup_pse->objectType = aux_cpy_ObjId(pse->objectType);
	dup_pse->objectValue = aux_cpy_OctetString(pse->objectValue);

	return(dup_pse);
}


PemInfo *aux_cpy_PemInfo(peminfo)
PemInfo *peminfo;
{
	PemInfo * dup_peminfo;
	char	* proc = "aux_cpy_PemInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!peminfo)
		return ( (PemInfo * ) 0);

	if ( !(dup_peminfo = (PemInfo * )malloc(sizeof(PemInfo))) ) {
		aux_add_error(EMALLOC, "dup_peminfo", CNULL, 0, proc);
		return ( (PemInfo * ) 0);
	}
	dup_peminfo->confidential = peminfo->confidential;
	dup_peminfo->clear = peminfo->clear;
	dup_peminfo->encryptKEY = aux_cpy_Key(peminfo->encryptKEY);
	dup_peminfo->origcert = aux_cpy_Certificates(peminfo->origcert);
	dup_peminfo->signAI = aux_cpy_AlgId(peminfo->signAI);
	dup_peminfo->recplist = aux_cpy_RecpList(peminfo->recplist);

	return(dup_peminfo);
}


PKRoot *aux_cpy_PKRoot(pkr)
PKRoot *pkr;
{
	PKRoot  * dup_pkr;
	char	* proc = "aux_cpy_PKRoot";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!pkr)
		return ( (PKRoot * ) 0);

	if ( !(dup_pkr = (PKRoot * )malloc(sizeof(PKRoot))) ) {
		aux_add_error(EMALLOC, "dup_pkr", CNULL, 0, proc);
		return ( (PKRoot * ) 0);
	}
	dup_pkr->ca = aux_cpy_DName(pkr->ca);
	dup_pkr->newkey = aux_cpy_Serial(pkr->newkey);
	dup_pkr->oldkey = aux_cpy_Serial(pkr->oldkey);

	return(dup_pkr);
}


IssuedCertificate *aux_cpy_IssuedCertificate(isscert)
IssuedCertificate *isscert;
{
	IssuedCertificate * dup_isscert;
	char	          * proc = "aux_cpy_IssuedCertificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (isscert == (IssuedCertificate * )0) )
		return ( (IssuedCertificate * )0 );
	if ( (dup_isscert = (IssuedCertificate * )malloc(sizeof(IssuedCertificate))) == (IssuedCertificate * )0 ) {
		aux_add_error(EMALLOC, "dup_isscert", CNULL, 0, proc);
		return ( (IssuedCertificate * )0 );
	}

	dup_isscert->serial = isscert->serial;
	dup_isscert->date_of_issue = aux_cpy_Name(isscert->date_of_issue);

	return( dup_isscert );
}


SET_OF_IssuedCertificate *aux_cpy_SET_OF_IssuedCertificate(isscertset)
SET_OF_IssuedCertificate *isscertset;
{
	SET_OF_IssuedCertificate * dup_isscertset;
	char			 * proc = "aux_cpy_SET_OF_IssuedCertificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!isscertset)
		return ( (SET_OF_IssuedCertificate * ) 0);

	if ( !(dup_isscertset = (SET_OF_IssuedCertificate * )malloc(sizeof(SET_OF_IssuedCertificate))) ) {
		aux_add_error(EMALLOC, "dup_isscertset", CNULL, 0, proc);
		return  ( (SET_OF_IssuedCertificate * ) 0);
	}
	dup_isscertset->element = aux_cpy_IssuedCertificate(isscertset->element);
	dup_isscertset->next = aux_cpy_SET_OF_IssuedCertificate(isscertset->next);

	return(dup_isscertset);
}


CrlPSE *aux_cpy_CrlPSE(crlpse)
CrlPSE *crlpse;
{
	CrlPSE * dup_crlpse;
	char   * proc = "aux_cpy_CrlPSE";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (crlpse == (CrlPSE * )0) )
		return ( (CrlPSE * )0 );
	if ( (dup_crlpse = (CrlPSE * )malloc(sizeof(CrlPSE))) == (CrlPSE * )0 ) {
		aux_add_error(EMALLOC, "dup_crlpse", CNULL, 0, proc);
		return ( (CrlPSE * )0 );
	}

	dup_crlpse->issuer = aux_cpy_DName(crlpse->issuer);
	dup_crlpse->nextUpdate = aux_cpy_Name(crlpse->nextUpdate);
	dup_crlpse->revcerts = aux_cpy_SEQUENCE_OF_RevCertPem(crlpse->revcerts);

	return ( dup_crlpse );
}


CrlSet *aux_cpy_CrlSet(crlset)
CrlSet *crlset;
{
	CrlSet * dup_crlset;
	char	   * proc = "aux_cpy_CrlSet";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!crlset)
		return ( (CrlSet * ) 0);

	if ( !(dup_crlset = (CrlSet * )malloc(sizeof(CrlSet))) ) {
		aux_add_error(EMALLOC, "dup_crlset", CNULL, 0, proc);
		return ( (CrlSet * ) 0);
	}
	dup_crlset->element = aux_cpy_CrlPSE(crlset->element);
	dup_crlset->next = aux_cpy_CrlSet(crlset->next);

	return(dup_crlset);
}


SET_OF_int *aux_cpy_SerialSet(serialset)
SET_OF_int *serialset;
{
	SET_OF_int * dup_serialset;
	char	   * proc = "aux_cpy_SerialSet";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!serialset)
		return ( (SET_OF_int * ) 0);

	if ( !(dup_serialset = (SET_OF_int * )malloc(sizeof(SET_OF_int))) ) {
		aux_add_error(EMALLOC, "dup_serialset", CNULL, 0, proc);
		return ( (SET_OF_int * ) 0);
	}
	dup_serialset->element = serialset->element;
	dup_serialset->next = aux_cpy_SerialSet(serialset->next);

	return(dup_serialset);
}


struct Serial *aux_cpy_Serial(serial)
struct Serial *serial;
{
	struct Serial   * dup_serial;
	char		* proc = "aux_cpy_Serial";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!serial)
		return ( (struct Serial * ) 0);

	if ( !(dup_serial = (struct Serial *)malloc(sizeof(struct Serial ))) ) {
		aux_add_error(EMALLOC, "dup_serial", CNULL, 0, proc);
		return ( (struct Serial * ) 0);
	}

	dup_serial->serial = serial->serial;
	dup_serial->key = aux_cpy_KeyInfo(serial->key);

	return (dup_serial);
} 


#include "iso3166.h"
#ifndef MAC
#include <ctype.h>
#endif /* MAC */

int	aux_check_3166 (a)
char	*a;
{
	int	bitno;

	if (strlen (a) != 2)
		return 0;

	if (islower ((u_char) a[0]))
		a[0] = toupper (a[0]);
	if (islower ((u_char) a[1]))
		a[1] = toupper (a[1]);

	return (isupper ((u_char) a[0]) && isupper((u_char) a[1]) && is3166 (a));
}


aux_check_print_string (str)
register char	*str;
{

	for (; *str != 0; str++) {
		if ((isascii((*str) & 0xff)) && (isalnum ((*str) & 0xff)))
			continue;      /*isascii() and isalnum() from /usr/include/ctype.h */

		switch (*str) {
		case 047:  /* ' */
		case '(':
		case ')':
		case '+':
		case '-':
		case '.':
		case ',':
		case '/':
		case ':':
		case '=':
		case '?':
		case ' ':
			continue;
		default:
			return (0);
		}
	}
	return (1);
}


/****************************************************************************/

extern int	errno;
Certificates * aux_create_Certificates(cert, fcpath)
Certificate  * cert;
FCPath       * fcpath;
{
	Certificates * certs;
	char	     * proc = "aux_create_Certificates";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!cert) {
		aux_add_error(EINVALID, "cert empty", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs = (Certificates * )calloc(1, sizeof(Certificates))))  {
		aux_add_error(EMALLOC, "certs", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs->usercertificate = aux_cpy_Certificate(cert))) {
		aux_add_error(EINVALID, "aux_cpy_Certificate failed", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if(fcpath) {
                if (!(certs->forwardpath = aux_cpy_FCPath(fcpath))) {
        		aux_add_error(EINVALID, "aux_cpy_FCPath failed", CNULL, 0, proc);
        		return ( (Certificates * )0);
        	}
        }

	return(certs);

}

/****************************************************************************/

extern int	errno;
PKRoot * aux_create_PKRoot(cert1, cert2)
Certificate  * cert1, *cert2;
{
	PKRoot * pkroot;
	struct Serial *newkey, *oldkey;
	char	     * proc = "aux_create_PKRoot";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!cert1) {
		aux_add_error(EINVALID, "cert1 empty", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot = (PKRoot * )calloc(1, sizeof(PKRoot))))  {
		aux_add_error(EMALLOC, "pkroot", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot->ca = aux_cpy_DName(cert1->tbs->subject))) {
		aux_add_error(EINVALID, "aux_cpy_DName failed", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(newkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
		aux_add_error(EMALLOC, "newkey", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	pkroot->newkey = newkey;
	newkey->serial = cert1->tbs->serialnumber;
	newkey->version = cert1->tbs->version;
	if(!(newkey->key = aux_cpy_KeyInfo(cert1->tbs->subjectPK))) {
		aux_add_error(EMALLOC, "newkey->key", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->notbefore = aux_cpy_String(cert1->tbs->notbefore))) {
		aux_add_error(EMALLOC, "newkey->notbefore", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->notafter = aux_cpy_String(cert1->tbs->notafter))) {
		aux_add_error(EMALLOC, "newkey->notafter", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->sig = aux_cpy_Signature(cert1->sig))) {
		aux_add_error(EMALLOC, "newkey->sig", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(cert2) {
		if (!(oldkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
			aux_add_error(EMALLOC, "oldkey", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		pkroot->oldkey = oldkey;
		oldkey->serial = cert2->tbs->serialnumber;
		oldkey->version = cert2->tbs->version;
		if(!(oldkey->key = aux_cpy_KeyInfo(cert2->tbs->subjectPK))) {
			aux_add_error(EMALLOC, "oldkey->key", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->notbefore = aux_cpy_String(cert2->tbs->notbefore))) {
			aux_add_error(EMALLOC, "oldkey->notbefore", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->notafter = aux_cpy_String(cert2->tbs->notafter))) {
			aux_add_error(EMALLOC, "oldkey->notafter", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->sig = aux_cpy_Signature(cert2->sig))) {
			aux_add_error(EMALLOC, "oldkey->sig", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
	}
		

	return(pkroot);

}

/****************************************************************************/

extern int	errno;
Certificate * aux_create_Certificate(tbs)
ToBeSigned  * tbs;
{
	Certificate * cert;
	char	    * proc = "aux_create_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!tbs) {
		aux_add_error(EINVALID, "tbs empty", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	if (!(cert = (Certificate * )malloc(sizeof(Certificate))))  {
		aux_add_error(EMALLOC, "cert", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	cert->tbs = aux_cpy_ToBeSigned(tbs);

	cert->sig = (Signature *)0;
	cert->tbs_DERcode = (OctetString *)0;

	return(cert);

}


/****************************************************************************/


int	aux_cmp_Certificate(a, b)
Certificate *a, *b;
{
	int	rc;

	if (!a || !b)
		return(1);

	if (a->tbs->serialnumber != b->tbs->serialnumber)
		return(1);

	return(aux_cmp_DName(a->tbs->issuer, b->tbs->issuer));
}



/****************************************************************************/

int	aux_cmp_CertificatePair(a, b)
CertificatePair *a, *b;
{
	int	rc;

	if (a->forward == (Certificate * ) 0) {
		if (b->forward == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->forward == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->forward, b->forward);
	}

	if (rc != 0)
		return (rc);

	if (a->reverse == (Certificate * ) 0) {
		if (b->reverse == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->reverse == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->reverse, b->reverse);
	}

	return (rc);
}



/****************************************************************************/

RevCert *aux_cpy_RevCert(revcert)
RevCert *revcert;
{
	int	  i, nob, lim;
	RevCert * dup_revcert;
	char	* proc = "aux_cpy_RevCert";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( revcert == (RevCert * )0 )
		return ( (RevCert * )0 );

	if ( !(dup_revcert = (RevCert * )malloc(sizeof(RevCert))) ) {
		aux_add_error(EMALLOC, "dup_revcert", CNULL, 0, proc);
		return ( (RevCert * )0 );
	}


	/*  Folgende Abfrage ist UNBEDINGT NOTWENDIG, da innerhalb von  ds_modifyentry()  
	 *  die Funktion entry_cpy()  aufgerufen wird, die die einzelnen Attribute 
	 *  innerhalb des betreffenden Eintrages kopiert (und nicht nur das zu modifizierende
	 *  Attribut!):                
	 * 		entryptr = entry_cpy (real_entry);
         */

	dup_revcert->tbs_DERcode = aux_cpy_OctetString(revcert->tbs_DERcode);
	dup_revcert->tbs = aux_cpy_RevCertTBS(revcert->tbs);
	dup_revcert->sig = aux_cpy_Signature(revcert->sig);


	return (dup_revcert);
}


RevCertTBS *aux_cpy_RevCertTBS(tbs)
RevCertTBS *tbs;
{
	RevCertTBS  * dup_tbs;
	char	    * proc = "aux_cpy_RevCertTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!tbs)
		return ( (RevCertTBS * ) 0);

	if ( !(dup_tbs = (RevCertTBS * )malloc(sizeof(RevCertTBS))) ) {
		aux_add_error(EMALLOC, "dup_tbs", CNULL, 0, proc);
		return ( (RevCertTBS * ) 0);
	}

	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->subject = tbs->subject;
	dup_tbs->revocationdate = aux_cpy_Name(tbs->revocationdate);

	return(dup_tbs);
}


SEQUENCE_OF_RevCert *aux_cpy_SEQUENCE_OF_RevCert(seq)
SEQUENCE_OF_RevCert *seq;
{
	SEQUENCE_OF_RevCert * dup_seq;
	char		    * proc = "aux_cpy_SEQUENCE_OF_RevCert";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (seq == (SEQUENCE_OF_RevCert * )0) )
		return ( (SEQUENCE_OF_RevCert * )0 );

	if ( !(dup_seq = (SEQUENCE_OF_RevCert * )malloc(sizeof(SEQUENCE_OF_RevCert))) ) {
		aux_add_error(EMALLOC, "dup_seq", CNULL, 0, proc);
		return ( (SEQUENCE_OF_RevCert * )0 );
	}
	/*copy first revoked certificate within the sequence:*/
	dup_seq->element = aux_cpy_RevCert(seq->element);
	dup_seq->next = aux_cpy_SEQUENCE_OF_RevCert(seq->next);

	return (dup_seq);
}


CrlTBS *aux_cpy_CrlTBS(tbs)
CrlTBS *tbs;
{
	CrlTBS * dup_tbs;
	char	   * proc = "aux_cpy_CrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!tbs)
		return ( (CrlTBS * ) 0);

	if ( !(dup_tbs = (CrlTBS * )malloc(sizeof(CrlTBS))) ) {
		aux_add_error(EMALLOC, "dup_tbs", CNULL, 0, proc);
		return ( (CrlTBS * ) 0);
	}

	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->lastupdate = aux_cpy_Name(tbs->lastupdate);
	dup_tbs->revokedcertificates = aux_cpy_SEQUENCE_OF_RevCert(tbs->revokedcertificates);

	return(dup_tbs);
}


Crl *aux_cpy_Crl(crl)
Crl *crl;
{
	int	  i, nob, lim;
	Crl * dup_crl;
	char	* proc = "aux_cpy_Crl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( crl == (Crl * )0 )
		return ( (Crl * )0 );

	if ( !(dup_crl = (Crl * )malloc(sizeof(Crl))) ) {
		aux_add_error(EMALLOC, "dup_crl", CNULL, 0, proc);
		return ( (Crl * )0 );
	}

	/*  Folgende Abfrage ist UNBEDINGT NOTWENDIG, da innerhalb von  ds_modifyentry()  
	 *  die Funktion entry_cpy()  aufgerufen wird, die die einzelnen Attribute 
	 *  innerhalb des betreffenden Eintrages kopiert (und nicht nur das zu modifizierende 
	 *  Attribut!):    
	 *		entryptr = entry_cpy (real_entry);
	 */

	dup_crl->tbs_DERcode = aux_cpy_OctetString(crl->tbs_DERcode);
	dup_crl->tbs = aux_cpy_CrlTBS(crl->tbs);
	dup_crl->sig = aux_cpy_Signature(crl->sig);

	return (dup_crl);
}


/*******************************************************************************
 *
 *      aux-routines for certificate revocation according to PEM
 *
 *******************************************************************************/

RevCertPem *aux_cpy_RevCertPem(revcertpem)
RevCertPem *revcertpem;
{
	RevCertPem * dup_revcertpem;
	char	   * proc = "aux_cpy_RevCertPem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( revcertpem == (RevCertPem * )0 )
		return ( (RevCertPem * )0 );

	if ( !(dup_revcertpem = (RevCertPem * )malloc(sizeof(RevCertPem))) ) {
		aux_add_error(EMALLOC, "dup_revcertpem", CNULL, 0, proc);
		return ( (RevCertPem * )0 );
	}

	dup_revcertpem->serialnumber = revcertpem->serialnumber;
	dup_revcertpem->revocationDate = aux_cpy_Name( revcertpem->revocationDate);

	return (dup_revcertpem);
}


SEQUENCE_OF_RevCertPem *aux_cpy_SEQUENCE_OF_RevCertPem(seq)
SEQUENCE_OF_RevCertPem *seq;
{
	SEQUENCE_OF_RevCertPem * dup_seq;
	char		       * proc = "aux_cpy_SEQUENCE_OF_RevCertPem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( (seq == (SEQUENCE_OF_RevCertPem * )0) )
		return ( (SEQUENCE_OF_RevCertPem * )0 );

	if ( !(dup_seq = (SEQUENCE_OF_RevCertPem * )malloc(sizeof(SEQUENCE_OF_RevCertPem))) ) {
		aux_add_error(EMALLOC, "dup_seq", CNULL, 0, proc);
		return ( (SEQUENCE_OF_RevCertPem * )0 );
	}
	/*copy first revoked certificate within the sequence:*/
	dup_seq->element = aux_cpy_RevCertPem(seq->element);
	dup_seq->next = aux_cpy_SEQUENCE_OF_RevCertPem(seq->next);

	return (dup_seq);
}


PemCrl *aux_cpy_PemCrl(pemcrl)
PemCrl *pemcrl;
{
	int	     i, nob, lim;
	PemCrl * dup_pemcrl;
	char	   * proc = "aux_cpy_PemCrl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( pemcrl == (PemCrl * )0 )
		return ( (PemCrl * )0 );

	if ( !(dup_pemcrl = (PemCrl * )malloc(sizeof(PemCrl))) ) {
		aux_add_error(EMALLOC, "dup_pemcrl", CNULL, 0, proc);
		return ( (PemCrl * )0 );
	}

	/*  Folgende Abfrage ist UNBEDINGT NOTWENDIG, da innerhalb von  ds_modifyentry()  
	 *  die Funktion entry_cpy()  aufgerufen wird, die die einzelnen Attribute 
	 *  innerhalb des betreffenden Eintrages kopiert (und nicht nur das zu modifizierende 
	 *  Attribut!):    
	 *		entryptr = entry_cpy (real_entry);
	 */

	dup_pemcrl->tbs_DERcode = aux_cpy_OctetString(pemcrl->tbs_DERcode);
	dup_pemcrl->tbs = aux_cpy_PemCrlTBS(pemcrl->tbs);
	dup_pemcrl->sig = aux_cpy_Signature(pemcrl->sig);

	return (dup_pemcrl);
}


PemCrlTBS *aux_cpy_PemCrlTBS(tbs)
PemCrlTBS *tbs;
{
	PemCrlTBS   * dup_tbs;
	char		* proc = "aux_cpy_PemCrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( tbs == (PemCrlTBS * )0 )
		return ( (PemCrlTBS * )0 );

	if ( !(dup_tbs = (PemCrlTBS * )malloc(sizeof(PemCrlTBS))) ) {
		aux_add_error(EMALLOC, "dup_tbs ", CNULL, 0, proc);
		return ( (PemCrlTBS * )0 );
	}

	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->revokedCertificates = aux_cpy_SEQUENCE_OF_RevCertPem(tbs->revokedCertificates);
	dup_tbs->lastUpdate = aux_cpy_Name(tbs->lastUpdate);
	dup_tbs->nextUpdate = aux_cpy_Name(tbs->nextUpdate);

	return (dup_tbs);
}


OCList *aux_cpy_OCList(ocl)
OCList *ocl;
{
	OCList  * dup_ocl;
	char	* proc = "aux_cpy_OCList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( ocl == (OCList * )0 )
		return ( (OCList * )0 );

	if ( !(dup_ocl = (OCList * )malloc(sizeof(OCList))) ) {
		aux_add_error(EMALLOC, "dup_ocl ", CNULL, 0, proc);
		return ( (OCList * )0 );
	}

	dup_ocl->serialnumber = ocl->serialnumber;
	dup_ocl->ccert = aux_cpy_Certificate(ocl->ccert);
	dup_ocl->next = aux_cpy_OCList(ocl->next);

	return (dup_ocl);
}



#ifdef SINIX

/*  This extension includes routines for SECUDE, which are not available
 *  on a MX300i.
 *
 *  Author: M. Munzert, SIEMENS AG, ZFE ST SN 5
 *  Date:   20.4.93
 */


#include <unistd.h>          /* setruid */


/* set (real) uid */

int setruid(uid_t uid)
{
  /* this routine may cause errors !!! */
  return (setuid(uid));
}


/* string compare, not case sensitive */

int strcasecmp(s1,s2)
char *s1, *s2;
{
  /* not yet implemented */
  printf("\n strcasecmp !!!\n");
  return (strcmp(s1,s2));
}

/* converts network byte-order ulongs to host byte-order */
/* conversion as necessary for MX300i */
/* mun: 29.4.93, SIEMENS AG, ZFE ST SN 5 */

unsigned long ntohl(netlong)
unsigned long netlong;
{
   unsigned long ret;

   ret = (netlong>>24)&0x000000ff; 
   ret += ((netlong>>8)&0x0000ff00);
   ret += ((netlong<<8)&0x00ff0000);
   ret += ((netlong<<24)&0xff000000);
   return(ret);
}

#endif
